asctime.c
/* Copyright (C) 1984 by Manx Software Systems */
#include <time.h>

char *
asctime(tm)
struct tm *tm;
{
	static char days[7][4] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
	};
	static char months[12][4] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
	static char buffer[26];

	sprintf(buffer, "%s %s %2d %02d:%02d:%02d %4d\n",
		days[tm->tm_wday], months[tm->tm_mon], tm->tm_mday,
		tm->tm_hour, tm->tm_min, tm->tm_sec, tm->tm_year+1900);
	return buffer;
}
ctime.c
/* Copyright (C) 1984 by Manx Software Systems */
#include <time.h>

char *
ctime(clock)
long *clock;
{
	struct tm *tm;

	tm = localtime(clock);
	return asctime(tm);
}
gettime.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<time.h>

get_time(tm)
register struct tm *tm;
{
	long t=time();
	register struct tm *ptr;
	ptr=localtime(&t);
	*tm = *ptr;
} 

localtim.c
/* Copyright (C) 1984 by Manx Software Systems */
#include <time.h>

struct tm *
gmtime(clock)
long *clock;
{
	struct tm *localtime();

	return localtime(clock);
}

struct tm *
localtime(clock)
long *clock;
{
	register long l;
	static struct tm tm;
	static int days[12] = {
		-1, 30, 58, 89, 119, 150, 180, 211, 242, 272, 303, 333
	};

	l = *clock;
	tm.tm_sec = 0;
	tm.tm_min = l&0xff;
	tm.tm_hour = (l >> 8) & 0xff;
	tm.tm_mday = (l >> 16) & 0x1f;
	tm.tm_mon = ((l >> 21) & 0x0f) - 1;
	tm.tm_year = ((l >> 25) & 0x7f);
	tm.tm_yday = days[tm.tm_mon] + tm.tm_mday +
					(tm.tm_mon > 1 && (tm.tm_year&3) == 0);
	tm.tm_wday = (tm.tm_yday + tm.tm_year + ((tm.tm_year-1)>>2) + 1) % 7;
	return &tm;
}

time.c
/* Copyright (C) 1985 by Manx Software Systems */
#include	<prodos.h>
#include	<sysfunc.h>
#include	<errno.h>
#include	<time.h>

/* tloc format

	00-07	minute
	08-15	hour
	16-20	day
	21-24	month
	25-31	year

*/

time_t
time(tloc)
time_t *tloc;
{
	register int err;
	register time_t l, save;

	save = *(long *)0xbf90;
	*(long *)0xbf90 = 0;
	if (err = _system(SYS_TIME)) {
		errno = err;
		return(-1L);
	}
	l = *(unsigned short *)0xbf90;
	l = (l<<16) | *(unsigned short *)0xbf92;
	if (l == 0) {
		l = (save>>16) | (save<<16);
		*(long *)0xbf90 = save;
	}
	if (tloc)
		*tloc = l;
	return(l);
} 

makefile
.SUFFIXES: .c .a65 .r .i

.c.r:
	cg65 +g0,8,80,10 -o $*.r $*.c
	sqz65 $*.r

.c.i:
	cci -ao $*.asm $*.c
	optint65 -ZAP $*.asm
	sqz65 $*.i

.a65.r:
	as65 -o $*.r $*.a65
	sqz65 $*.r

SRC= asctime.c ctime.c gettime.c localtim.c time.c

REL= asctime.r ctime.r gettime.r localtim.r time.r

INT= asctime.i ctime.i gettime.i localtim.i time.i

rel: $(REL)
	echo done

int: $(INT)
	echo done
